; -------------------------------------------------------------------------------------------------------------- ;
; Bounty Bob Strikes Back Original (Copy Protected) - bob-data.prg
; -------------------------------------------------------------------------------------------------------------- ;
; Protection: Checks error on t22s10 (usual simple ocean protection) - Update "Bounty Bob" if found
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ $0d00
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes

C64CIA1                 include c64_cia1.asm              ; Complex Interface Adapter (CIA) #1 Registers  $dc00-$dc0f
C64CIA2                 include c64_cia2.asm              ; Complex Interface Adapter (CIA) #2 Registers  $dd00-$dd0f
C64SID                  include c64_sid.asm               ; Sound Interface Device (SID) Registers        $d400-$d41c
C64VicII                include c64_vic.asm               ; Video Interface Chip (VIC-II) Registers       $d000-$d02e
C64Colors               include c64_color.asm             ; Colour RAM Address / Colours
C64Kernal               include c64_kernal.asm            ; Kernal Routines entry points                  $e000-$ffff
C64Memory               include c64_mem.asm               ; Standard Zeropage / Stack / Vector constants
; -------------------------------------------------------------------------------------------------------------- ;
; External Addresses
; -------------------------------------------------------------------------------------------------------------- ;
EntryPoint_BountyBob    = $2e64                     ; BountyBob module entry point
EntryPoint_BobLoad      = $0845                     ; Bob-Load  module entry point
; -------------------------------------------------------------------------------------------------------------- ;
; BobData_Main          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobData_Main            subroutine                  ; 
                        jsr ReadAndCheckBlocks      ; check copy protection
                        
.GetResult              lda TabCheckProtResult      ; 
.WasBad                 beq BobData_MainX           ; was bad
; -------------------------------------------------------------------------------------------------------------- ;
; Modify Bounty Bob Entry Point
; -------------------------------------------------------------------------------------------------------------- ;
.WasGood                lda #$d8                    ; cld
                        sta [EntryPoint_BountyBob + $00] ; 
                        
                        lda #$78                    ; sei
                        sta [EntryPoint_BountyBob + $01] ; 
                        
                        lda #$a2                    ; ldx #$..
                        sta [EntryPoint_BountyBob + $02] ; 
                        
BobData_MainX           jmp EntryPoint_BountyBob    ; jump to modified BontyBob entry point
; -------------------------------------------------------------------------------------------------------------- ;
; ReadAndCheckBlocks    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ReadAndCheckBlocks      subroutine                  ; 
                        jsr CLALL                   ; Kernal($FFE7) Close all files (via $32C to $F32F)
; -------------------------------------------------------------------------------------------------------------- ;
; OPEN 15,8,15,"I0:" - command channel with init drive 0
; -------------------------------------------------------------------------------------------------------------- ;
.DriveResetIni          ldx #<DiskCmdInitialize     ; reset drive and read bam into its internal memory
                        ldy #>DiskCmdInitialize     ; 
                        lda #DiskCmdInitializeLen   ; 
                        jsr SETNAM                  ; Kernal($FFBD) Set filename parameters ($FDF9)
                        
.CommandChannel         lda #$0f                    ; 
                        tay                         ; 
                        ldx #$08                    ; 
                        jsr SETLFS                  ; Kernal($FFBA) Set logical file parameters ($FE00)
.DriveReset             jsr OPEN                    ; Kernal($FFC0) Open a logical file (via $31A to $F34A)
; -------------------------------------------------------------------------------------------------------------- ;
; OPEN 2,8,2,"#" - direct access channel - let 1541 choose a free buffer
; -------------------------------------------------------------------------------------------------------------- ;
.DataChannel            lda #$02                    ; logical file number
                        tay                         ; secondary command number
                        ldx #$08                    ; device number
                        jsr SETLFS                  ; Kernal($FFBA) Set logical file parameters ($FE00)
                        
                        lda #DiskCmdHashLen         ; 
                        ldx #<DiskCmdHash           ; 
                        ldy #>DiskCmdHash           ; 
                        jsr SETNAM                  ; Kernal($FFBD) Set filename parameters ($FDF9)
                        jsr OPEN                    ; Kernal($FFC0) Open a logical file (via $31A to $F34A)
                        
.Set1st_22_15           lda #"5"                    ; 
.Out1st                 jsr SendDiskCmd             ; B-R (Block-Read) -> U1:2,0,22,15 (U1:channel,drive,track,block)
.Get1st_Err             jsr ReadErrorChannel        ; 
                        
.Chk1st_CR              cmp #$0d                    ; carriage return
                        beq .Get1st_Err             ; 
                        
.Chk1st_Zero            cmp #"0"                    ; 
                        bne CloseAllAndReturnBad    ; 
                        
.Set2nd_22_10           lda #"0"                    ; 
.Out2nd                 jsr SendDiskCmd             ; B-R (Block-Read) -> U1:2,0,22,10 (U1:channel,drive,track,block)
.Get2nd_Err             jsr ReadErrorChannel        ; 
                        
.Chk2nd_CR              cmp #$0d                    ; carriage return
                        beq .Get2nd_Err             ; 
                        
.Chk2nd_Two             cmp #"2"                    ; "2n" - any disk error
                        bne CloseAllAndReturnBad    ; 
                        
.Set3rd_22_15           lda #"5"                    ; 
.Out3rd                 jsr SendDiskCmd             ; B-R (Block-Read) -> U1:2,0,22,15 (U1:channel,drive,track,block)
.Get3rd_Err             jsr ReadErrorChannel        ; 
                        
.Chk3rd_CR              cmp #$0d                    ; carriage return
                        beq .Get3rd_Err             ; 
                        
.Chk3rd_Zero            cmp #"0"                    ; 
                        bne CloseAllAndReturnBad    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CloseAllAndReturnGood Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CloseAllAndReturnGood   subroutine                  ;                   
                        lda #$02                    ; 
                        jsr CLOSE                   ; Kernal($FFC3) Close a logical file (via $31C to $F291)
                        
                        lda #$0f                    ; 
                        jsr CLOSE                   ; Kernal($FFC3) Close a logical file (via $31C to $F291)
                        
                        lda #$ff                    ; 
                        sta TabCheckProtResult      ; 
                        
CloseAllAndReturnGoodX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CloseAllAndReturnBad  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CloseAllAndReturnBad    subroutine                  ;                   
                        lda #$02                    ; 
                        jsr CLOSE                   ; Kernal($FFC3) Close a logical file (via $31C to $F291)
                        
                        lda #$0f                    ; 
                        jsr CLOSE                   ; Kernal($FFC3) Close a logical file (via $31C to $F291)
                        
                        lda #$00                    ; 
                        sta TabCheckProtResult      ; 
                        
CloseAllAndReturnBadX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ReadErrorChannel      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ReadErrorChannel        subroutine                  ; 
.CmdChannel             ldx #$0f                    ; 
                        jsr CHKIN                   ; Kernal($FFC6) Define an input channel (via $31E to $F20E)
.Char_Get               jsr GETIN                   ; Kernal($FFE4) Get a character (via $32A to $F13E)
                        
.Char_Save              pha                         ; 
                        
                        jsr CLRCHN                  ; Kernal($FFCC) Restore default devices (via $322 to $F333)
                        
.Char_Restore           pla                         ; 
                        
ReadErrorChannelX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SendDiskCmd           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SendDiskCmd             subroutine                  ; 
                        sta DiskCmdReadBlockSecLo   ; 
                        
                        lda #$08                    ; 
                        jsr LISTEN                  ; Kernal($FFB1) Serial bus device to LISTEN ($ED0C)
                        
                        lda #$6f                    ; $60 + command channel $0f
                        jsr SECOND                  ; Kernal($FF93) Send 2ndry address after LISTEN ($EDB9)
                        
                        ldx #$00                    ; 
                        
.SavCmdU1Pos            txa                         ; 
                        pha                         ; 
                        
.GetCmdU1               lda DiskCmdReadBlock,x      ; 
.ChkCmdU1               beq .Complete               ; 
                        
.OutCmdU1               jsr CIOUT                   ; Kernal($FFA8) Output byte to serial bus ($EDDD)
                        
.SetCmdU1Next           pla                         ; 
                        tax                         ; 
                        
                        inx                         ; 
                        bne .SavCmdU1Pos            ; always
                        
.Complete               pla                         ; 
                        
                        jsr UNLSN                   ; Kernal($FFAE) Serial bus device to UNLISTEN ($EDFE)
                        
SendDiskCmdX            rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
DiskCmdInitialize       equ *    ; 
                        dc.b $49 ; I
                        dc.b $30 ; 0
                        dc.b $3a ; :
DiskCmdInitializeLen    equ  [* - DiskCmdInitialize] ; 
; -------------------------------------------------------------------------------------------------------------- ;
DiskCmdHash             equ *    ; 
                        dc.b $23 ; #
DiskCmdHashLen          equ [* - DiskCmdHash] ; 
; -------------------------------------------------------------------------------------------------------------- ;
DiskCmdReadBlock        equ *    ; 
                        dc.b $55 ; U
                        dc.b $31 ; 1
                        dc.b $3a ; :
                        dc.b $32 ; 2
                        dc.b $2c ; ,
                        dc.b $30 ; 0
                        dc.b $2c ; ,
                        dc.b $32 ; 2
                        dc.b $32 ; 2
                        dc.b $2c ; ,
                        dc.b $31 ; 1
DiskCmdReadBlockSecLo   dc.b $34 ; 4
                        
DiskCommandStringX      dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $ff ; 
                        dc.b $a9 ; lda #$ea
                        dc.b $ea ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabCheckProtResult      dc.b $8d ; sta $0328
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $28 ; 
                        dc.b $03 ; 
                        dc.b $a9 ; lda #$d2
                        dc.b $d2 ; 
                        dc.b $8d ; sta $1006
                        dc.b $06 ; 
                        dc.b $10 ; 
                        dc.b $a9 ; lda #$ff
                        dc.b $ff ; 
                        dc.b $8d ; sta $1007
                        dc.b $07 ; 
                        dc.b $10 ; 
                        dc.b $60 ; rts
; -------------------------------------------------------------------------------------------------------------- ;
A_0de8                  dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
A_0df0                  dc.b $ff ; 
; -------------------------------------------------------------------------------------------------------------- ;
